/*!
 *******************************************************************************
 * \file             spi_tclMySpinVrStream.h
 * \brief            Copy audio data from an ALSA source to an ALSA sink
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3 Projects
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Copy audio data from an ALSA source to an ALSA sink
 COPYRIGHT:      &copy; BSOT

 HISTORY:
 Date       |  Author                          | Modifications
 08.10.2015 |  Tobias Quintern (BSOT/ENG)      | Initial version
 05.01.2016 |  Tobias Quintern (BSOT/ENG)      | Changed public interface for increased flexibility

 \endverbatim
 ******************************************************************************/

#ifndef __SPI_TCL_MYSPINALSASTREAM_H__
#define __SPI_TCL_MYSPINALSASTREAM_H__

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include <string>
#include <stdint.h>
#include <mspin_vr_stream.h>



class spi_tclMySpinVrStream
{

 protected:
    static U32 m_u32InstanceCounter;

 private:

    U32 m_u32Id;
    std::string m_szThreadName;

    // Device handles of capture and playback devices
    snd_pcm_t *m_potrCaptureHandle;
    snd_pcm_t *m_potrPlaybackHandle;

    bool m_bThreadRunning;
    pthread_t m_threadId;
    
    /* Generic configuration */
    snd_pcm_access_t m_enAccess;
    snd_pcm_format_t m_enFormat;
    unsigned int m_u32Channels;
    unsigned int m_u32Rate;

    /* Capture and Playback specific configuration */
    vrDeviceConfig m_rCaptureDeviceConfig;
    vrDeviceConfig m_rPlaybackDeviceConfig;

    /* Callback functions */
    vrStreamCallbacks m_rMySpinAlsaStreamCallbacks;

    /* Internal functions */
    S32 s32SetHwParams( snd_pcm_t *potrDeviceHandle ,
                            const bool cobSetBufferSizeAndPeriodSize ,
                            const snd_pcm_uframes_t cou32BufferSize ,
                            const snd_pcm_uframes_t cou32PeriodSize);

    S32 s32XrunRecovery(snd_pcm_t *handle, S32 err);

    S32 s32WriteBuffer( U32 u32Id, snd_pcm_t *const potrDeviceHandle,  const U8 *const copu8ReadBuffer, const U32 cou32FramesToWrite );

    S32 s32OpenAlsaDevice( vrDeviceConfig *porDeviceConfig , snd_pcm_t **popotrDeviceHandle ,  snd_pcm_stream_t enStreamType );

    void vCloseAlsaDevice( snd_pcm_t **m_popotrDeviceHandle );
        
    static void* povCopyThread(void *pArg);
    

 public:
    
    /*! \brief Constructor */
    spi_tclMySpinVrStream();

    /*! \brief Destructor */
    ~spi_tclMySpinVrStream();

    /*! \brief Function registers error callback functions */
    void vRegisterCallbacks( U32 cou32Context , vrStreamCallbacks vrStreamCallbacks );

    /*! \brief Start copying of audio data from Capture to Playback device */
    S32 s32StartVRStream( const vrDeviceConfig corCaptureDeviceConfig ,
                              const vrDeviceConfig corPlaybackDeviceConfig ,
                              const snd_pcm_access_t coenAccess ,
                              const snd_pcm_format_t coenFormat ,
                              const unsigned int cou32Channels ,
                              const unsigned int cou32Samplerate );

    /*! \brief Stop copying of audio data from Capture to Playback device */
    S32 s32StopVrStream();
    
    
};



#endif /* __SPI_TCL_MYSPINALSASTREAM_H__ */
